package fr.uga.miashs.attenteactive;

/**
 * First trivial "non" alternative that does not guaranty 
 * mutual exclusion.
 * It is an example of "Lock Variable" described p124 of "modern operating system, 4th ed"
 * 
 * @author jerome.david@univ-grenoble-alpes.fr
 *
 */
public class AlternativeLock1 implements SpinLock {
	
	private volatile boolean occupee;
	
	// init_sc
	public AlternativeLock1() {
		occupee=false;
	}
	
	public void enterCriticalRegion(int pId) {
		while (occupee) {
			// do nothing
			//System.out.println("Processus "+ pId + " est en attente");
		}
		
		occupee=true;
		//System.out.println("Processus "+ pId + " entre");
	}
	
	public void exitCriticalRegion(int pId) {
		//System.out.println("Processus "+ pId + " sort");
		occupee=false;
	}

}
