package fr.uga.miashs.attenteactive;
import java.util.Arrays;

/**
 * Alternative d'attente active avec tableau de booléens 
 * qui indiquent qui veut entrer en section critique.
 * Exclusion mutuelle assurée mais risque d’interblocage.
 * @author jerome.david@univ-grenoble-alpes.Fr
 *
 */
public class AlternativeLock2 implements SpinLock {
	
	public volatile boolean[] demandes;
	
	// init_sc
	public AlternativeLock2() {
		demandes = new boolean[2];
		Arrays.fill(demandes, false);
	}

	public void enterCriticalRegion(int pId) {
		demandes[pId]=true;
		while (demandes[1-pId]) {
			// do nothing
		}
		

	}

	public void exitCriticalRegion(int pId) {
		demandes[pId]=false;
	}

}
