package fr.uga.miashs.attenteactive;

/**
 * Alternatice d'attente active avec variable entière tour
 * pour assurer l’alternance.
 * Exclusion mutuelle assurée mais risque de famine
 * 
 * @author jerome.david@univ-grenoble-alpes.fr
 *
 */
public class AlternativeLock3 implements SpinLock {

	private volatile int tour;
	
	// init_sc
	public AlternativeLock3() {
		tour=0;
	}
	
	public void enterCriticalRegion(int pId) {
		while (tour!=pId) {
			// do nothing
		}

	}

	public void exitCriticalRegion(int pId) {
		tour=1-pId;

	}

}
