package fr.uga.miashs.attenteactive;
import java.util.Arrays;

/**
 * Vrai solution d'attente active de Dekker-Peterson.
 * Mélange les fausses solutions AlternativeLock2 et AlternativeLock3
 * Garantie d'exclusion mutuelle sans interblocage (dealock) ni famine (starvation).
 * See p125 of book "modern operating system, 4th ed"
 * @author jerome.david@univ-grenoble-alpes.fr
 *
 */

public class AlternativeLock4Peterson implements SpinLock{

	
	private volatile boolean[] demandes;
	private volatile int tour;
	
	public AlternativeLock4Peterson() {
		demandes=new boolean[2];
		Arrays.fill(demandes, false);
		tour=0;
	}
	
	public void enterCriticalRegion(int pId) {
		demandes[pId]=true;
		tour=1-pId;
		while (tour!=pId && demandes[1-pId]) {
			// do nothing
		}
		
		
	}

	public void exitCriticalRegion(int pId) {
		demandes[pId]=false;
		
	}

}
