package fr.uga.miashs.attenteactive;

/**
 * Simulate a process that increments a shared value.
 * It extends the Thread class which can be viewed as a lightweight process.
 * @author jerome.david@univ-grenoble-alpes.fr
 *
 */
public class MyProcess extends Thread {

	private int nbIncrements;
	
	private int pId;
	
	private SharedValue value;
	private SpinLock verrou;
	
	private int nbIterations;
	
	public MyProcess(int pId, SharedValue value, SpinLock verrou, int nbIterations) {
		if (pId<0 ||pId>1) {
			throw new IllegalArgumentException("pId must be 0 or 1: "+pId);
		}
		this.value=value;
		this.verrou=verrou;
		this.pId=pId;
		this.nbIterations=nbIterations;
		nbIncrements=0;
	}
	
	// we repeat nbIterations times the operation of incrementing the shared value
	public void run() {
		for (int j=0; j<nbIterations ; j++) {
			verrou.enterCriticalRegion(pId);
			// j'utilise ce découpage pour que ca soit plus simple à comprendre
			// mais j'aurais pu aussi utilisé value.increment();
			// et observer les mêmes problèmes (vous pouvez essayer si vous n'y croyez pas). 
			int lu = value.getValue();
			value.setValue(lu+1);
			nbIncrements+=1;
			verrou.exitCriticalRegion(pId);
		}
	}
	
	public int getNbIncrements() {
		return nbIncrements;
	}	
	
}
