package fr.uga.miashs.attenteactive;

/**
 * 
 * @author jdavid
 *
 */
public class ProgTest {
	public static void main(String[] args) {

		// With new AlternativeLock1(), you will see that
		// sharedValue.getValue() may be different from t1.getNbIncrements() + t2.getNbIncrements()
		// this appends randomly, so you have to execute the program several times
		
		// With new AlternativeLock2(), the program may block (deadlock)
		// this appends randomly, so you have to execute the program several times
		
		
		// With new AlternativeLock3(), the program may block (starvation/"famine")
		// this appends if you comment t1.start()
		
		// with new AlternativeLock4Peterson() it always works well
		SpinLock verrou = new NoLock();
		
		SharedValue v = new SharedValue();
		
		int nbIterations=500;
		
		
		MyProcess p1 = new MyProcess(0,v, verrou,nbIterations);
		MyProcess p2 = new MyProcess(1,v, verrou,nbIterations);

		// .start() launches the run() method of MyProcess which is a thread (i.e. a kind of process)
		// this means that .start() ask to execute run() method in parallel manner
		// comment p1.start(); if you want to see the starvation pb (famine) in AlternativeLock3
		System.out.println("START process p1");
		p1.start();
		System.out.println("START process p2");
		p2.start();

		try {

			// Wait the end of the two processes
			p1.join();
			p2.join();

			// Print the results
			// we expect that v.getValue() == (p1.getNbIncrements()+p2.getNbIncrements())
			// but this not always the case...
			System.out.println("Valeur de sharedValue : " + v.getValue());
			System.out.println("Valeur de i de p1 + i de p2 : " + (p1.getNbIncrements() + p2.getNbIncrements()));

		} catch (InterruptedException e) {
			e.printStackTrace();
		}

	}
}
