/* --------------------------------------------------------------------------- 
 * Schéma de création de processus.
 * Création d'un processus fils et test pour exécuter un code différent
 * dans le père et dans le fils.
 */

#include <stdio.h>		/* Pour perror */
#include <stdlib.h>		/* Pour exit */
#include <unistd.h>		/* Pour fork, getpid, getppid, sleep */
#include <sys/types.h>		/* Pour pid_t (fork, getpid, getppid) */
#include <sys/wait.h>		/* Pour wait */

int main(void)
{
  pid_t ident;

  ident = fork();
  if (ident == -1)
  {
    perror("fork");
    return EXIT_FAILURE;
  }

  /* A partir de cette ligne, il y deux processus */
  printf("Cette ligne sera affichée deux fois\n");
  if (ident == 0)
  {
    /* Code exécuté uniquement par le fils */
    printf("Je suis le fils\n");

  }
  else
  {
    /* Code exécuté uniquement par le pere */
    printf("Je suis le père\n");
  }

  return EXIT_SUCCESS;
}
